#!/bin/sh

# script ran through lantek4-init.service to power on CCMB and to connect UART to FiberTEK

RhCpu=$(grep UltraLite /proc/cpuinfo)

RH=0
if [ "$RhCpu" != "" ]; then
    RH=1
fi

enableCCMB() {
    ccmb=164
    if [ $RH -eq 1 ]; then
        ccmb=119
    fi

    echo "power up CCMB gpio $ccmb"
    gpio_dir="/sys/class/gpio/gpio"$ccmb
    if [ ! -d $gpio_dir ]; then
        echo "setting up CCMB gpio $ccmb"
        echo $ccmb > /sys/class/gpio/export
        echo 1 > $gpio_dir/value
        #only set direction if not already 'out' - else we get glitch in gpio signal!
        if [ "$(cat $gpio_dir/direction)" != "out" ]; then
            echo out > $gpio_dir/direction
        fi
        echo 1 > $gpio_dir/value
    fi
    #to be sure.. set to 1 again!
    echo 1 > $gpio_dir/value
}

enableRhFiberTEK() {
    FIBERTEK_GPIO_MODULE=rhgpiofibertek
    FIBERTEK_GPIO_MODULE_PATH=/opt/LanTEK/drivers/${FIBERTEK_GPIO_MODULE}.ko

    #now assign the use of pin "GPIO6"(1) / "ENET2 MDIO"(0) to GPIO6 use so I can drive to a 0 for MUX selection for Fibertek if required
    insmod $FIBERTEK_GPIO_MODULE_PATH select=1
    rmmod $FIBERTEK_GPIO_MODULE

    #using gpio mux control.. connect UART5 to Fibertek (0) - not STM32 (1)
    gpio_dir="/sys/class/gpio/gpio6"
    if [ ! -d $gpio_dir ]; then
        echo "setting gpio6 uart mux"
        echo 6 > /sys/class/gpio/export
        echo out > $gpio_dir/direction
        echo 0 > $gpio_dir/value
    fi

    #now assign the use of pin "GPIO6"(1) / "ENET2 MDIO"(0) to MDIO use so that CCMB eth can work
    insmod $FIBERTEK_GPIO_MODULE_PATH select=0
    rmmod $FIBERTEK_GPIO_MODULE
}

enableDhFiberTEK() {
    #using gpio mux control..route imx6 uart4 for FiberTek(0) - rather than STM32(1)
    gpio_dir="/sys/class/gpio/gpio43"
    if [ ! -d $gpio_dir ]; then
        echo "setting gpio43 uart mux"
        echo 43 > /sys/class/gpio/export
        echo out > $gpio_dir/direction
        echo 0 > $gpio_dir/value
    fi
}

enableCCMB

if [ $RH -eq 1 ]; then
    enableRhFiberTEK
else
    enableDhFiberTEK
fi

/opt/LanTEK/scripts/first-boot.sh
